<?php
/**
 * Materials Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;

class Materials extends BaseController {

	/**
	 * Constructor CodeIgniter
	 */
	public function __construct() {
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Materials_model');
		$this->load->model('Units_model');
	}
	
	public function index() {
		$data['content_title'] = 'Material';

		$this->twiggy_display('adm/materials/index', $data);

	}

	public function get_data() {
		$data = [];
		$get_data = $this->Materials_model->get_data()->result();

		if($get_data) {
			$no=1;
			foreach($get_data as $get_row) {

				$data[] = array(
					'no'        => $no,
					'id'        => $get_row->material_id,
					'code'      => $get_row->material_code,
					'name'      => $get_row->material_name,
					'minstock'  => $get_row->material_minstock,
					'maxstock'  => $get_row->material_maxstock,
					'unit_id'   => $get_row->unit_id,
					'unit_name'  => $get_row->unit_name,
				);
			$no++;
			}
		}

		$response = [ 
			'data'         => $data,
			'recordsTotal' => count($data)
		];

		output_json($response);
	}

	public function edit($id='new') {
		$title    = "Tambah";
		$get_data = array();

		if($id != 'new') {
			$title    = "Edit";
			$where = array('material_id' => $id);
			$get_data = $this->Materials_model->get_data($where)->row_array();
		}

		$data['id']            = $id;
		$data['content_title'] = $title;
		$data['get_data']      = $get_data;
		$data['unit_data'] 	= $this->Units_model->get_data()->result();

		$this->twiggy_display('adm/materials/edit', $data);
	}

	public function save() {
		// post
		$id        = $this->input->post('id');
		$code      = $this->input->post('code');
		$name      = $this->input->post('name');
		$unit      = $this->input->post('unit');
		$min_stock = $this->input->post('min_stock');
		$max_stock = $this->input->post('max_stock');
		$action    = $this->input->post('action');

		$data_save = array(
			'material_code'     => $code,
			'material_name'     => $name,
			'material_minstock' => $min_stock,
			'material_maxstock' => $max_stock,
			'material_unit_id'  => $unit
		);

		if($id == 'new') {
			$convert = convert_button($action, $id);
			$save = $this->Materials_model->save($data_save);
		} else {
			$convert = convert_button($action, $id);
			$save = $this->Materials_model->update($id, $data_save);
		}

		if($save) {
			$response = array(
				'status'  => 'success',
				'message' => 'Berhasil menyimpan data',
				'id'      => $convert
			);
		}

		else {
			$response = array(
				'status'  => 'error',
				'message' => 'Gagal menyimpan data',
				'id'      => $convert
			);
		}

		output_json($response);
	}

	public function delete() {
		$id = $this->input->post('id');

		foreach($id as $row) {
			$delete_type = $this->Materials_model->delete($row);
		}

		$response = array(
			'message' => 'Berhasil menghapus data',
			'status'  => 'success'
		);

		output_json($response);
	}

	public function check_id() {
		$name  = $this->input->post('id');
		$where = array('material_code' => $name);

		$check = $this->Materials_model->check_id($where);

		if ($check) {
			$response = array('status' => true);
		} else {
			$response = array('status' => false);
		}

		output_json($response);
	}

}

?>
